/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.compat.waila.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.dries007.tfc.ConfigTFC;
import net.dries007.tfc.TerraFirmaCraft;
import net.dries007.tfc.compat.waila.interfaces.IWailaBlock;
import net.dries007.tfc.objects.blocks.agriculture.BlockBerryBush;
import net.dries007.tfc.objects.te.TETickCounter;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.CalendarTFC;
import net.dries007.tfc.util.calendar.Month;
import net.dries007.tfc.util.climate.ClimateTFC;
import net.dries007.tfc.world.classic.chunkdata.ChunkDataTFC;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BerryBushProvider
implements IWailaBlock {
    @Override
    @Nonnull
    public List<String> getTooltip(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull NBTTagCompound nbt) {
        ArrayList<String> currentTooltip = new ArrayList<String>();
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockBerryBush) {
            BlockBerryBush block = (BlockBerryBush)state.func_177230_c();
            if (block.getBush().isHarvestMonth(CalendarTFC.CALENDAR_TIME.getMonthOfYear()) && !((Boolean)state.func_177229_b((IProperty)BlockBerryBush.FRUITING)).booleanValue()) {
                float temp = ClimateTFC.getActualTemp(world, pos);
                float rainfall = ChunkDataTFC.getRainfall(world, pos);
                TETickCounter te = Helpers.getTE((IBlockAccess)world, pos, TETickCounter.class);
                if (te != null && block.getBush().isValidForGrowth(temp, rainfall)) {
                    long hours = te.getTicksSinceUpdate() / 1000L;
                    float perc = Math.min(0.99f, (float)hours / (block.getBush().getGrowthTime() * (float)ConfigTFC.General.FOOD.berryBushGrowthTimeModifier)) * 100.0f;
                    String growth = String.format("%d%%", Math.round(perc));
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.growth", new Object[]{growth}).func_150254_d());
                } else {
                    currentTooltip.add(new TextComponentTranslation("waila.tfc.crop.not_growing", new Object[0]).func_150254_d());
                }
            } else {
                currentTooltip.add(new TextComponentTranslation("waila.tfc.agriculture.harvesting_months", new Object[0]).func_150254_d());
                for (Month month : Month.values()) {
                    if (!block.getBush().isHarvestMonth(month)) continue;
                    currentTooltip.add(TerraFirmaCraft.getProxy().getMonthName(month, true));
                }
            }
        }
        return currentTooltip;
    }

    @Override
    @Nonnull
    public List<Class<?>> getLookupClass() {
        return Collections.singletonList(BlockBerryBush.class);
    }
}

